-- new script file

local waveMedium = {}
local mission = {}

function OnAfterSceneLoaded(self)
  CreateTriggerTargets(self)
	CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.spawnPos = Vision.hkvVec3()
    mission.enemy = Citadels.GetPlayer(1)
    self.attackPoint = Game:GetEntity("P0-thallT-D2-0"):GetPosition()
	
	  if not self.loaded then
		  self.active = false
			self.attCounter = 0
		  self.baseCount = 100 * Citadels.GetPlayer(0):GetDifficultyCoef()
	  end
    
    self.handlerMedium:LinkToTarget("waveActive")
  end
  
  if self.active then
		if self.attCounter > 1 then
			UpgradeWave(self)
		end
    InitializeWave(self)
		ChooseSpawnPoint(self)
    AttackWave(self)
		self.handlerMedium:TriggerAllTargets()
		self.attCounter = self.attCounter + 1
    self.active = false
  end  
end

function InitializeWave(self)
  waveMedium['unit_L_archer_L2'] = self.baseCount * 0.12
  waveMedium['unit_L_fman_L2'] = self.baseCount * 0.1
	waveMedium['unit_L_arbalist_L1'] = self.baseCount * 0.1
	waveMedium['unit_L_rider_L1'] = self.baseCount * 0.08
	waveMedium['unit_L_catapult_L1'] = self.baseCount * 0.02
end

function UpgradeWave(self)
	self.baseCount = self.baseCount + 20
end

function ChooseSpawnPoint(self)
	rand = math.random(0, 11)
	
	if rand >= 0 and rand <= 3 then
		self.spawnPos = Game:GetEntity('spawnPos-1'):GetPosition()
	elseif rand > 3 and rand <= 7 then
		self.spawnPos = Game:GetEntity('spawnPos-2'):GetPosition()
	elseif rand > 7 then
		self.spawnPos = Game:GetEntity('spawnPos-4'):GetPosition()
	end
end

function AttackWave(self)
  for prefab,ammount in pairs(waveMedium) do
    mission.enemy:AttackGroupAdd(prefab, ammount)
  end
  mission.enemy:AttackGroupSetModeToSpawn() -- units will be spawned ( not trainded ) around rallypoint
  mission.enemy:AttackGroupAllowedTargetIndex(0) --attack only at player index 0 - human player
  mission.enemy:AttackGroupAddWayPoints(self.attackPoint)
  mission.enemy:AttackGroupCommit(1, self.spawnPos, 20)
end

function OnTrigger(self, source, target)
  if target == "attMedium" then
    self.active = true
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
		CreateTriggerSources(self)
    self.loaded = true
		self.active = ar:Read()
		self.attCounter = ar:Read()
		self.baseCount = ar:Read()
  elseif (ar:IsSaving()) then
		ar:Write(self.active)
		ar:Write(self.attCounter)
		ar:Write(self.baseCount)
	end
end

function CreateTriggerTargets(self)
  self:AddTriggerTarget("attMedium")
end

function CreateTriggerSources(self)
  self:AddTriggerSource("handlerMedium")
end
